/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskNameService;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;
import oracle.ops.verification.util.MultiNodeException;

public class TaskScan
extends Task
implements CVUHelperConstants {
    private final String TNSPING_EXE = "tnsping ";
    private final String TNSPING_ERR_PATTERN = "^TNS-[0-9]+:.*";
    private final String TNSPING_SUCC_PATTERN = "^OK \\([0-9]+ .*\\)";
    private final String SCAN_HELPER_ARG = "-getscan";
    private static int MIN_SCAN_IPS = 3;
    private String m_localName = null;
    private boolean m_isPreCRS = false;

    public TaskScan(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskScan(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskScan(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    public void setIsPreCRS(boolean isPreCRS) {
        this.m_isPreCRS = isPreCRS;
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5050", false));
        retVal = this.m_isPreCRS ? this.performTaskPre() : this.performTaskPost();
        if (retVal) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5058", false));
        } else {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5054", false));
        }
        return retVal;
    }

    public boolean performTaskPost() {
        NativeSystem nativeSystem;
        String errMsg = null;
        Object scanName = null;
        Object scanAddress = null;
        Object scanUserAssignedName = null;
        Object lsnrName = null;
        Object runNode = null;
        LinkedList<ErrorDescription> errorDetails = new LinkedList<ErrorDescription>();
        boolean vipRun = false;
        boolean lsnrRun = false;
        boolean isResourceRunning = true;
        int status = 2;
        boolean port = false;
        ErrorDescription errDesc = null;
        String exeHome = VerificationUtil.getCRSHome();
        Version crsVer = VerificationUtil.getCRSActiveVersionObj();
        if (exeHome != null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("exeHome = '" + exeHome + "'"));
            }
        } else {
            errMsg = s_msgBundle.getMessage("5301", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        this.m_localName = this.m_nodeList[0];
        String[] args = new String[]{"-getscan"};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            errMsg = s_gMsgBundle.getMessage("1002", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            errMsg = s_gMsgBundle.getMessage("1002", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        String[] output = helperExec.getOutput();
        String[] scanDetailsArr = null;
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                errorArray = CVUHelperUtil.fetchError(output);
            } else if (status == 1) {
                Trace.out((String)"partial success with data collection");
                scanDetailsArr = CVUHelperUtil.fetchOutput(output);
                errorArray = CVUHelperUtil.fetchError(output);
                if (scanDetailsArr.length == 0) {
                    Trace.out((String)"all failure");
                }
            } else {
                Trace.out((String)"all data collected");
                scanDetailsArr = CVUHelperUtil.fetchOutput(output);
            }
        } else {
            Trace.out((String)"cvuhelper failed to produce output");
            errMsg = s_gMsgBundle.getMessage("1002", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        if (status != 0) {
            ErrorDescription errorDesc;
            if (errorArray.length >= 1) {
                Trace.out((String)"cvuhelper returned error");
                errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                ReportUtil.printError(errMsg);
            } else {
                Trace.out((String)"cvu helper didn't succeed. But no error was returned");
                errMsg = s_gMsgBundle.getMessage("1002", true, (Object[])new String[]{helperExec.getCommandString()});
                errMsg = errMsg + helperExec.getOutputString();
                errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                ReportUtil.printError(errMsg);
            }
        }
        List<Scan> scans = null;
        if (Version.isPre12c((Version)crsVer)) {
            Trace.out((String)"getting Scan details in pre 12g way");
            List<scanData> sd = this.getScanDetailsPre12(scanDetailsArr);
            if (sd.size() > 0) {
                Scan s = new Scan();
                s.sName = sd.get(0).getVIPName();
                ClusterNetworkInfo cnInfo = null;
                try {
                    cnInfo = ClusterNetworkInfo.getNetworkInfoFromOifcfg();
                }
                catch (CVUException cvuEx) {
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    errMsg = cvuEx.getMessage();
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    ReportUtil.printError(errMsg);
                    return false;
                }
                cnInfo = cnInfo.getClusterNetworkInfo(2);
                s.netIpv4Subnet = cnInfo.getSubnets()[0];
                s.sdList = sd;
                scans = new ArrayList<Scan>();
                scans.add(s);
            }
        } else {
            Trace.out((String)"getting Scan details in 12g way");
            scans = this.getScanDetails(scanDetailsArr);
        }
        if (scans == null || scans.size() == 0) {
            errMsg = s_msgBundle.getMessage("5053", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        boolean headerPrinted = false;
        Integer portID = -1;
        boolean portsMatch = true;
        boolean portsErrMsg = false;
        for (Scan scan : scans) {
            if (headerPrinted) {
                ReportUtil.blankln();
            }
            List<scanData> scanDetails = scan.sdList;
            for (scanData scanItem : scanDetails) {
                if (!headerPrinted) {
                    headerPrinted = true;
                    ReportUtil.writeColHeaders(s_msgBundle.getMessage("4658", false), s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("8059", false), s_msgBundle.getMessage("8060", false), s_msgBundle.getMessage("8003", false));
                }
                if (portID == -1) {
                    portID = scanItem.getPort();
                }
                if (portID != scanItem.getPort() || portID == -1) {
                    portsMatch = false;
                }
                String vipRunning = scanItem.getVipRunning() ? "true" : "false";
                String lsnrRunning = scanItem.getLsnrRunning() ? "true" : "false";
                String portStr = portID.toString();
                ReportUtil.writeRecord(scanItem.getVIPName(), scanItem.getVipNode(), vipRunning, scanItem.getLsnrName(), portStr, lsnrRunning);
                if (!scanItem.getLsnrRunning() || !scanItem.getVipRunning()) {
                    isResourceRunning = false;
                    errDesc = new ErrorDescription("5056", new String[]{scanItem.getLsnrName()}, s_msgBundle);
                    errorDetails.add(errDesc);
                    this.m_resultSet.addResult(this.m_localName, 3);
                    this.m_resultSet.getResult(this.m_localName).addErrorDescription(errDesc);
                }
                if (portsMatch || portsErrMsg) continue;
                isResourceRunning = false;
                portsErrMsg = true;
                errDesc = new ErrorDescription("5057", new String[]{scanItem.getLsnrName()}, s_msgBundle);
                errorDetails.add(errDesc);
                this.m_resultSet.addResult(this.m_localName, 3);
                this.m_resultSet.getResult(this.m_localName).addErrorDescription(errDesc);
            }
        }
        for (ErrorDescription errMsgs : errorDetails) {
            ReportUtil.printError(errMsgs.getErrorMessage());
        }
        if (!this.m_resultSet.anyFailure()) {
            Trace.out((String)"about to run tnsping check");
            for (Scan scan : scans) {
                this.performTnsPingCheck(scan.sdList, exeHome);
            }
        } else {
            Trace.out((String)"skipping tnsping check");
        }
        if (this.m_resultSet.getStatus() == 1 && this.m_nodeList.length > 2) {
            HashSet<String> scanVIPRunningNodes = new HashSet<String>();
            for (Scan scan : scans) {
                for (scanData sd : scan.sdList) {
                    scanVIPRunningNodes.add(sd.getVipNode());
                }
            }
            if (scanVIPRunningNodes.size() == 1) {
                Iterator itr = scanVIPRunningNodes.iterator();
                String node = null;
                if (itr.hasNext()) {
                    node = (String)itr.next();
                }
                errMsg = s_msgBundle.getMessage("5065", true, (Object[])new String[]{node});
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_localName, 4);
                this.m_resultSet.getResult(this.m_localName).addErrorDescription(errDesc);
                ReportUtil.println(errMsg);
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        if ((nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
            boolean oraDevEnv = VerificationUtil.isCVUTestEnv();
            String nameValue = new String("bigip-bug.us.oracle.com");
            Trace.out((int)5, (String)("ora dev env: '" + oraDevEnv + "'"));
            ArrayList<String> scanVIPNameList = new ArrayList<String>();
            for (Scan scan : scans) {
                for (scanData scanEntry : scan.sdList) {
                    Trace.out((int)5, (String)("\nScan Data : \n" + scanEntry.toString()));
                    if (!oraDevEnv) {
                        nameValue = scanEntry.getVIPName();
                    }
                    if (scanVIPNameList.contains(nameValue)) continue;
                    scanVIPNameList.add(nameValue);
                    TaskNameService taskNS = new TaskNameService(this.m_nodeList, nameValue, this.m_resultSet);
                    taskNS.performTask();
                }
            }
        }
        block14: for (Scan scan : scans) {
            if (scan.netIpv4Subnet == null || scan.netiPv4DhcpType != DHCPServerType.NONE) continue;
            InetAddress[] scanVips = null;
            try {
                scanVips = InetAddress.getAllByName(scan.sName);
            }
            catch (UnknownHostException uhe) {
                errMsg = s_gMsgBundle.getMessage("11374", true, (Object[])new String[]{scan.sName});
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errMsg);
                continue;
            }
            if (scanVips.length != scan.sdList.size()) {
                errMsg = s_gMsgBundle.getMessage("11372", true, (Object[])new String[]{scan.sName});
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errMsg);
                return false;
            }
            scanData firstSD = scan.sdList.get(0);
            boolean ipv4Present = firstSD.l_scanIpv4Address != null;
            boolean ipv6Present = firstSD.l_scanIpv6Address != null;
            Trace.out((String)("frst scan Data: " + firstSD.toString()));
            for (scanData sd : scan.sdList) {
                if (sd.l_scanIpv4Address != null == ipv4Present && sd.l_scanIpv6Address != null == ipv6Present) continue;
                Trace.out((String)("mismatched scanData :" + sd.toString()));
                errMsg = s_msgBundle.getMessage("11373", true, (Object[])new String[]{scan.sName});
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errMsg);
                continue block14;
            }
        }
        ArrayList<String> subs = new ArrayList<String>();
        for (Scan scan : scans) {
            if (scan.netIpv4Subnet != null) {
                subs.add(scan.netIpv4Subnet);
            }
            if (scan.netIpv6Subnet == null) continue;
            subs.add(scan.netIpv6Subnet);
        }
        ClusterNetworkInfo cnInfo = new ClusterNetworkInfo(subs.toArray(new String[0]));
        this.performSubnetCheck(scans, cnInfo);
        if (isResourceRunning && this.m_resultSet.allSuccess()) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        this.m_resultSet.addResult(this.m_nodeList, 3);
        return false;
    }

    private List<scanData> getScanDetailsPre12(String[] helperOut) {
        LinkedList<scanData> scanDetails = new LinkedList<scanData>();
        String[] scanDetailsArr = helperOut;
        ArrayList<String> scanNameList = new ArrayList<String>();
        if (scanDetailsArr != null && scanDetailsArr.length > 0) {
            Trace.out((String)("there are " + scanDetailsArr.length + " scan info"));
            for (int i = 0; i < scanDetailsArr.length; ++i) {
                Trace.out((String)("scan details = " + scanDetailsArr[i]));
                String scanLine = VerificationUtil.fetchTextByTags(scanDetailsArr[i], null, "<SCN_DETAILS>", "</SCN_DETAILS>");
                if (scanLine == null || scanLine.length() == 0) {
                    Trace.out((String)"not processing as scan info");
                    continue;
                }
                String scanName = VerificationUtil.fetchTextByTags(scanLine, null, "<SCN_NME>", "</SCN_NME>");
                String scanUserAssignedName = VerificationUtil.fetchTextByTags(scanDetailsArr[i], null, "<USR_ASGN_NAME>", "</USR_ASGN_NAME>");
                String scanAddress = VerificationUtil.fetchTextByTags(scanLine, null, "<SCN_ADDR>", "</SCN_ADDR>");
                String runNode = VerificationUtil.fetchTextByTags(scanLine, null, "<RUN_NODE>", "</RUN_NODE>");
                String lsnrName = VerificationUtil.fetchTextByTags(scanLine, null, "<LSNR_NME>", "</LSNR_NME>");
                String portStr = VerificationUtil.fetchTextByTags(scanLine, null, "<LSNR_PORT>", "</LSNR_PORT>");
                int port = -1;
                if (portStr != null && portStr.length() != 0) {
                    port = Integer.parseInt(portStr);
                }
                String vipRunStr = VerificationUtil.fetchTextByTags(scanLine, null, "<VIP_RUN>", "</VIP_RUN>");
                boolean vipRun = false;
                if (vipRunStr != null && vipRunStr.length() != 0) {
                    vipRun = Boolean.valueOf(vipRunStr);
                }
                String lsnrRunStr = VerificationUtil.fetchTextByTags(scanLine, null, "<LSNR_RUN>", "</LSNR_RUN>");
                boolean lsnrRun = false;
                if (lsnrRunStr != null && lsnrRunStr.length() != 0) {
                    lsnrRun = Boolean.valueOf(lsnrRunStr);
                }
                if (scanUserAssignedName == null || scanNameList.contains(scanUserAssignedName)) continue;
                scanNameList.add(scanUserAssignedName);
                scanDetails.add(new scanData(scanName, scanUserAssignedName, scanAddress, null, runNode, lsnrName, port, vipRun, lsnrRun));
            }
        }
        return scanDetails;
    }

    private List<Scan> getScanDetails(String[] helperOut) {
        ArrayList<Scan> scans = new ArrayList<Scan>();
        if (helperOut == null || helperOut.length == 0) {
            Trace.out((String)"No scan data");
            return scans;
        }
        for (String scanLine : helperOut) {
            String[] subnets;
            String sName = null;
            DHCPServerType netIpv4DhcpType = null;
            String netIpv4Subnet = null;
            DHCPServerType netIpv6DhcpType = null;
            String netIpv6Subnet = null;
            Trace.out((String)("scan details = " + scanLine));
            sName = VerificationUtil.fetchTextByTags(scanLine, "<SCN_NME>", "</SCN_NME>");
            Trace.out((String)("sName=" + sName));
            if (sName == null || sName.length() == 0) {
                Trace.out((String)"scanName is invalid. not processing scan info");
                continue;
            }
            String netDeatails = VerificationUtil.fetchTextByTags(scanLine, "<NET_DETAILS>", "</NET_DETAILS>");
            Trace.out((String)("netDeatails=" + netDeatails));
            if (netDeatails == null || netDeatails.length() == 0) {
                Trace.out((String)"netDeatails is invalid. not processing scan info");
                continue;
            }
            String dhcpType = VerificationUtil.fetchTextByTags(netDeatails, "<DHCP_TYPE_IPV4>", "</DHCP_TYPE_IPV4>");
            if (dhcpType != null && dhcpType.length() > 0) {
                netIpv4DhcpType = DHCPServerType.getMember((String)dhcpType);
            }
            if ((dhcpType = VerificationUtil.fetchTextByTags(netDeatails, "<DHCP_TYPE_IPV6>", "</DHCP_TYPE_IPV6>")) != null && dhcpType.length() > 0) {
                netIpv6DhcpType = DHCPServerType.getMember((String)dhcpType);
            }
            String strSubnets = VerificationUtil.fetchTextByTags(netDeatails, "<SUBNETS>", "</SUBNETS>");
            Trace.out((String)("strSubnets = " + strSubnets));
            if (strSubnets == null || strSubnets.length() == 0) {
                Trace.out((String)"strSubnets is not valid. not processing scan info");
                continue;
            }
            for (String strSubnet : subnets = VerificationUtil.fetchTextByTagsRepeat(strSubnets, "<SUBNET_DETAILS>", "</SUBNET_DETAILS>")) {
                Trace.out((String)("strSubnet= " + strSubnet));
                String subnetType = VerificationUtil.fetchTextByTags(netDeatails, "<SUBNET_TYPE>", "</SUBNET_TYPE>");
                String subnet = VerificationUtil.fetchTextByTags(netDeatails, "<SUBNET>", "</SUBNET>");
                IPAddressUtil.IPAddrType addrType = IPAddressUtil.getIPAddrTypeMember((String)subnetType);
                if (addrType == IPAddressUtil.IPAddrType.IPv4) {
                    netIpv4Subnet = subnet;
                    continue;
                }
                if (addrType != IPAddressUtil.IPAddrType.IPv6) continue;
                netIpv6Subnet = subnet;
            }
            String[] sVipDetails = VerificationUtil.fetchTextByTagsRepeat(scanLine, "<SCN_DETAILS>", "</SCN_DETAILS>");
            LinkedList<scanData> sdList = new LinkedList<scanData>();
            for (String sVipDetail : sVipDetails) {
                String strRun;
                String[] vipAddrs;
                Object vipName = null;
                String scanIpv4Address = null;
                String scanIpv6Addres = null;
                String vipUserAssignedName = null;
                String vipNode = null;
                String lsnrName = null;
                int portNum = -1;
                boolean vipRunning = false;
                boolean lsnrRunning = false;
                Trace.out((String)("sVipDetail : " + sVipDetail));
                vipUserAssignedName = VerificationUtil.fetchTextByTags(sVipDetail, "<USR_ASGN_NAME>", "</USR_ASGN_NAME>");
                for (String vipAddr : vipAddrs = VerificationUtil.fetchTextByTagsRepeat(sVipDetail, "<SCN_ADDR_DETAILS>", "</SCN_ADDR_DETAILS>")) {
                    Trace.out((String)("vipAddr = " + vipAddr));
                    String strAddrType = VerificationUtil.fetchTextByTags(vipAddr, "<ADDR_TYPE>", "</ADDR_TYPE>");
                    String strAddr = VerificationUtil.fetchTextByTags(vipAddr, "<SCN_ADDR>", "</SCN_ADDR>");
                    IPAddressUtil.IPAddrType addrType = IPAddressUtil.getIPAddrTypeMember((String)strAddrType);
                    if (addrType == IPAddressUtil.IPAddrType.IPv4) {
                        scanIpv4Address = strAddr;
                        continue;
                    }
                    if (addrType != IPAddressUtil.IPAddrType.IPv6) continue;
                    scanIpv6Addres = strAddr;
                }
                vipNode = VerificationUtil.fetchTextByTags(sVipDetail, "<RUN_NODE>", "</RUN_NODE>");
                lsnrName = VerificationUtil.fetchTextByTags(sVipDetail, "<LSNR_NME>", "</LSNR_NME>");
                String strPort = VerificationUtil.fetchTextByTags(sVipDetail, "<LSNR_PORT>", "</LSNR_PORT>");
                if (strPort != null && strPort.length() != 0) {
                    portNum = Integer.parseInt(strPort);
                }
                if ((strRun = VerificationUtil.fetchTextByTags(sVipDetail, "<VIP_RUN>", "</VIP_RUN>")) != null && strRun.length() != 0) {
                    vipRunning = Boolean.valueOf(strRun);
                }
                if ((strRun = VerificationUtil.fetchTextByTags(sVipDetail, "<LSNR_RUN>", "</LSNR_RUN>")) != null && strRun.length() != 0) {
                    lsnrRunning = Boolean.valueOf(strRun);
                }
                scanData sd = new scanData(sName, vipUserAssignedName, scanIpv4Address, scanIpv6Addres, vipNode, lsnrName, portNum, vipRunning, lsnrRunning);
                sdList.add(sd);
            }
            Scan s = new Scan();
            s.sName = sName;
            s.netiPv4DhcpType = netIpv4DhcpType;
            s.netIpv4Subnet = netIpv4Subnet;
            s.netIpv6DhcpType = netIpv6DhcpType;
            s.netIpv6Subnet = netIpv6Subnet;
            s.sdList = sdList;
            scans.add(s);
        }
        return scans;
    }

    private void performTnsPingCheck(List<scanData> scanDetails, String exeHome) {
        String tnsPingPath = exeHome + FSEP + "bin" + FSEP + "tnsping ";
        ArrayList<scanData> runningLsnrList = new ArrayList<scanData>();
        StringBuffer errSB = new StringBuffer();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnix = nativeSystem.isUnixSystem();
        for (scanData scanItem : scanDetails) {
            if (!scanItem.getLsnrRunning()) continue;
            runningLsnrList.add(scanItem);
        }
        if (runningLsnrList.size() == 0) {
            return;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5066", false));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8059", false), s_msgBundle.getMessage("8061", false));
        for (scanData lsnrItem : runningLsnrList) {
            String connectString = null;
            String displayConnectString = null;
            String scanVIP = lsnrItem.getAddress();
            if (scanVIP == null) {
                Trace.out((String)("ipv4 address was not found for scan VIP name: " + lsnrItem.getVIPName() + ". Getting ipv6 address"));
                scanVIP = lsnrItem.getIpv6Address();
            }
            if (scanVIP == null) {
                String errMsg = s_msgBundle.getMessage("5053", true);
                errSB.append(LSEP + errMsg);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                continue;
            }
            if (scanVIP.startsWith("/")) {
                scanVIP = scanVIP.substring(1);
            }
            if (isUnix) {
                connectString = "\\'\\(DESCRIPTION=\\(ADDRESS=\\(PROTOCOL=tcp\\)\\(HOST=" + scanVIP + "\\)\\(PORT=" + lsnrItem.getPort() + "\\)\\)\\)\\'";
                if (!VerificationUtil.isLocalNode(this.m_localName)) {
                    connectString = "\"" + connectString + "\"";
                }
                displayConnectString = "'(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + scanVIP + ")(PORT=" + lsnrItem.getPort() + ")))'";
            } else {
                connectString = "\"(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + scanVIP + ")(PORT=" + lsnrItem.getPort() + ")))\"";
                displayConnectString = "\"(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + scanVIP + ")(PORT=" + lsnrItem.getPort() + ")))\"";
            }
            String lsnrName = lsnrItem.getLsnrName();
            String tnsPingCmd = tnsPingPath + connectString;
            String displayCmd = tnsPingPath + displayConnectString;
            Trace.out((String)("cmd = " + tnsPingCmd));
            Trace.out((String)("running tnsping from node " + this.m_localName));
            ResultSet rsltSet = new ResultSet();
            GlobalExecution globalExec = new GlobalExecution();
            if (isUnix) {
                tnsPingCmd = "-cv_oh " + exeHome + " " + tnsPingCmd;
            }
            globalExec.runExe(new String[]{this.m_localName}, tnsPingCmd, rsltSet);
            Hashtable rsltTab = rsltSet.getResultTable();
            Enumeration e = rsltTab.keys();
            while (e.hasMoreElements()) {
                boolean parseFlag = false;
                String reportStatus = ReportUtil.YES;
                String node = (String)e.nextElement();
                Result result = (Result)rsltTab.get(node);
                if (result.getStatus() == 1) {
                    String output = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().get(1));
                    boolean execRes = VerificationUtil.fetchExecResult((String)result.getResultInfoSet().get(1));
                    output = output.trim();
                    Trace.out((String)("\nCommand output for: " + node + "\nOutput: " + output + "\n"));
                    Trace.out((String)("execResult = " + execRes));
                    if (output == null || output.length() == 0) {
                        Trace.out((String)"no output or command failed");
                        this.m_resultSet.addResult(node, 2);
                        String errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{displayCmd, node});
                        ErrorDescription errDesc = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(node, errDesc);
                        errSB.append(LSEP + errMsg);
                        reportStatus = ReportUtil.NO;
                    } else {
                        String[] outlist = (String[])result.getResultInfoSet().get(0);
                        Vector outLines = new Vector();
                        for (int l = 0; l < outlist.length; ++l) {
                            outLines.addAll(VerificationUtil.getTokens(outlist[l], LSEP));
                        }
                        for (String line : outLines) {
                            if (line.matches("^OK \\([0-9]+ .*\\)")) {
                                parseFlag = true;
                                Trace.out((String)("tns ping success line = " + line));
                                reportStatus = ReportUtil.YES;
                                this.m_resultSet.addResult(node, 1);
                                break;
                            }
                            if (line.matches("^TNS-[0-9]+:.*")) {
                                parseFlag = true;
                                reportStatus = ReportUtil.NO;
                                Trace.out((String)("tns ping error line =" + line));
                                String errMsg = s_msgBundle.getMessage("5067", true, (Object[])new String[]{lsnrName, node}) + LSEP + line;
                                errSB.append(LSEP + errMsg);
                                this.m_resultSet.addResult(node, 3);
                                ErrorDescription errDesc = new ErrorDescription(errMsg);
                                this.m_resultSet.addErrorDescription(node, errDesc);
                                break;
                            }
                            Trace.out((String)("out line=" + line));
                        }
                        if (!parseFlag) {
                            ErrorDescription errDesc;
                            String errMsg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{displayCmd, output});
                            errSB.append(LSEP + errMsg);
                            if (!execRes) {
                                reportStatus = ReportUtil.NO;
                                this.m_resultSet.addResult(node, 3);
                                errDesc = new ErrorDescription(errMsg);
                                this.m_resultSet.addErrorDescription(node, errDesc);
                                Trace.out((String)"output not parsed and exit status not 0");
                            } else {
                                reportStatus = ReportUtil.YES;
                                this.m_resultSet.addResult(node, 1);
                                errDesc = new ErrorDescription(errMsg);
                                this.m_resultSet.addErrorDescription(node, errDesc);
                                Trace.out((String)"successful because of exit status");
                            }
                        }
                    }
                } else {
                    reportStatus = ReportUtil.NO;
                    this.m_resultSet.addResult(node, 2);
                    String errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{displayCmd, node});
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                    errSB.append(LSEP + errMsg);
                }
                ReportUtil.writeRecord(node, lsnrName, reportStatus);
            }
        }
        if (errSB.length() != 0) {
            ReportUtil.sureprintln(errSB.toString());
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5068", false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performTaskPre() {
        Exception ex = null;
        boolean retVal = true;
        String scanName = null;
        String errMsg = null;
        try {
            InetAddress[] scanAddrs;
            ClusterNetworkInfo cnInfo = ClusterNetworkInfo.getNetworkInfoFromCVUVar();
            cnInfo = cnInfo.getClusterNetworkInfo(2);
            String pubSubnet = cnInfo.getSubnets()[0];
            IPAddressUtil.IPAddrType ipType = IPAddressUtil.getIPAddrTypeFromIPAddress((String)pubSubnet);
            scanName = VerificationUtil.getVariableValue("SCAN_NAME");
            Scan s = new Scan();
            s.sName = scanName;
            if (ipType == IPAddressUtil.IPAddrType.IPv6) {
                s.netIpv6Subnet = pubSubnet;
                s.netIpv6DhcpType = DHCPServerType.getMember((String)"static");
            } else {
                s.netIpv4Subnet = pubSubnet;
                s.netiPv4DhcpType = DHCPServerType.getMember((String)"static");
            }
            s.sdList = new ArrayList<scanData>();
            for (InetAddress scanAddr : scanAddrs = InetAddress.getAllByName(scanName)) {
                Trace.out((String)("scanAddr = " + scanAddr));
                String addressIpv4 = null;
                String addressIpv6 = null;
                if (scanAddr instanceof Inet4Address) {
                    addressIpv4 = scanAddr.getHostAddress();
                    Trace.out((String)("addressIpv4=" + addressIpv4 + " is an ipv4 address"));
                } else {
                    addressIpv6 = scanAddr.getHostAddress();
                    Trace.out((String)("addressIpv6=" + addressIpv6 + " is an ipv6 address"));
                }
                scanData sd = new scanData(scanName, scanName, addressIpv4, addressIpv6, null, null, -1, false, false);
                s.sdList.add(sd);
            }
            ArrayList<Scan> scans = new ArrayList<Scan>();
            scans.add(s);
            retVal = this.performSubnetCheck(scans, cnInfo);
        }
        catch (CVUException cvuEx) {
            ex = cvuEx;
            errMsg = cvuEx.getMessage();
            Trace.out((String)("CVUException occured. message: " + errMsg));
        }
        catch (UnknownHostException uhEx) {
            Trace.out((String)("cvuEx occured. message: " + uhEx.getMessage()));
            errMsg = s_gMsgBundle.getMessage("11374", true, (Object[])new String[]{scanName});
            ex = uhEx;
        }
        finally {
            if (ex != null) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                ReportUtil.printError(errMsg);
                retVal = false;
            } else {
                this.m_resultSet.addResult(this.m_nodeList, 1);
            }
        }
        return retVal;
    }

    private boolean performSubnetCheck(List<Scan> scans, ClusterNetworkInfo cnInfo) {
        boolean retVal = true;
        ArrayList<InterfaceInfo> ifInfoList = new ArrayList<InterfaceInfo>();
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11365", false));
        try {
            cnInfo = cnInfo.getClusterNetworkInfo(2);
            VerifyNetwork vfyNet = new VerifyNetwork();
            Trace.out((String)("trying to get interface information on node " + this.m_nodeList[0]));
            vfyNet.getInterfaceInfo(this.m_nodeList[0], cnInfo, ifInfoList);
            for (Scan scan : scans) {
                List<scanData> activeSDs;
                Trace.out((String)("checking SCAN IP addresses of SCAN " + scan.sName));
                ArrayList<scanData> badSdList = new ArrayList<scanData>();
                Trace.out((String)"classifying scan ips by subnet");
                Map<String, List<scanData>> subnetMap = this.classifyVIPsBySubnet(scan, ifInfoList, badSdList);
                if (badSdList.size() != 0) {
                    StringBuilder ipv4Ips = new StringBuilder();
                    StringBuilder ipv6Ips = new StringBuilder();
                    for (scanData sd : badSdList) {
                        if (sd.l_scanIpv4Address != null) {
                            if (ipv4Ips.length() != 0) {
                                ipv4Ips.append(',');
                            }
                            ipv4Ips.append(sd.l_scanIpv4Address);
                        }
                        if (sd.l_scanIpv6Address == null) continue;
                        if (ipv6Ips.length() != 0) {
                            ipv6Ips.append(',');
                        }
                        ipv6Ips.append(sd.l_scanIpv6Address);
                    }
                    String errMsg = null;
                    if (ipv4Ips.length() != 0) {
                        Trace.out((String)("SCAN IPs " + ipv4Ips + " can not be on any of the public subnets " + scan.netIpv4Subnet));
                        errMsg = this.m_isPreCRS ? s_gMsgBundle.getMessage("11366", true, (Object[])new String[]{ipv4Ips.toString(), scan.sName, scan.netIpv4Subnet}) : s_gMsgBundle.getMessage("11367", true, (Object[])new String[]{ipv4Ips.toString(), scan.sName, scan.netIpv4Subnet});
                        this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
                        ReportUtil.sureprintln(errMsg);
                        this.m_resultSet.addResult(this.m_nodeList, 3);
                        retVal = false;
                    }
                    if (ipv6Ips.length() != 0) {
                        Trace.out((String)("SCAN IPs " + ipv6Ips + " can not be on any of the public subnets " + scan.netIpv6Subnet));
                        errMsg = this.m_isPreCRS ? s_gMsgBundle.getMessage("11366", true, (Object[])new String[]{ipv6Ips.toString(), scan.sName, scan.netIpv6Subnet}) : s_gMsgBundle.getMessage("11367", true, (Object[])new String[]{ipv6Ips.toString(), scan.sName, scan.netIpv6Subnet});
                        this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
                        ReportUtil.sureprintln(errMsg);
                        this.m_resultSet.addResult(this.m_nodeList, 3);
                        retVal = false;
                    }
                }
                if (badSdList.size() == scan.sdList.size()) {
                    Trace.out((String)"All SCAN IP addresses are bad.");
                    retVal = false;
                    continue;
                }
                if (scan.netIpv4Subnet != null && scan.netiPv4DhcpType != DHCPServerType.NONE || scan.netIpv6Subnet != null && scan.netIpv6DhcpType != DHCPServerType.AUTOCONFIG) {
                    Trace.out((String)"SCAN VIP are not GNS configured. skip minimun number of SCAN VIPs check");
                    continue;
                }
                for (String subnet : subnetMap.keySet()) {
                    List<scanData> sdList = subnetMap.get(subnet);
                    if (sdList.size() >= MIN_SCAN_IPS || sdList.size() == 1) continue;
                    String strScanIps = this.getScanIps(sdList);
                    String ipsNeeded = Integer.toString(MIN_SCAN_IPS - sdList.size());
                    Trace.out((String)("Scan Ips must be more than " + ipsNeeded + " but only " + strScanIps + " were found on subnet " + subnet));
                    String errMsg = s_gMsgBundle.getMessage("11368", true, (Object[])new String[]{String.valueOf(MIN_SCAN_IPS), scan.sName, strScanIps});
                    this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
                    ReportUtil.printWarning(errMsg);
                    this.m_resultSet.addResult(this.m_nodeList, 4);
                    retVal = false;
                }
                if (!this.m_isPreCRS || VerificationUtil.isUpgrade() || (activeSDs = this.checkReachability(scan.sdList, true)).size() <= 0) continue;
                String errMsg = s_gMsgBundle.getMessage("11369", true, (Object[])new String[]{this.getScanIps(activeSDs), scan.sName});
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                ReportUtil.sureprintln(errMsg);
                retVal = false;
            }
        }
        catch (NetworkException ne) {
            Trace.out((String)("NETWORK EXCEPTION: " + ne.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
            ReportUtil.printError(ne.getMessage());
            retVal = false;
        }
        catch (MultiNodeException mnEx) {
            Trace.out((String)("MultiNodeException EXCEPTION: " + mnEx.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(mnEx.getMessage()));
            ReportUtil.printError(mnEx.getMessage());
            retVal = false;
        }
        if (retVal) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11370", false));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11371", false));
        }
        return retVal;
    }

    private List<scanData> checkReachability(List<scanData> sdList, boolean bActive) {
        ClusterCmd cmd = new ClusterCmd();
        ArrayList<scanData> retVals = new ArrayList<scanData>();
        String[] nodes = null;
        for (scanData sd : sdList) {
            try {
                if (sd.l_scanIpv4Address != null && sd.l_scanIpv6Address != null) {
                    nodes = new String[]{sd.l_scanIpv4Address, sd.l_scanIpv6Address};
                } else if (sd.l_scanIpv4Address != null) {
                    nodes = new String[]{sd.l_scanIpv4Address};
                } else if (sd.l_scanIpv6Address != null) {
                    nodes = new String[]{sd.l_scanIpv6Address};
                } else {
                    Trace.out((String)("both addresses are null. scanData: " + sd.toString()));
                    continue;
                }
                if (cmd.areNodesAlive(nodes, 30, null) != bActive) continue;
                retVals.add(sd);
            }
            catch (ClusterException cex) {
                Trace.out((String)("CLUSTEREXCEPTION: calling areNodesAlive message: " + cex.getMessage()));
                VerificationLogData.logError("CLUSTEREXCEPTION: " + cex.getMessage() + "\n" + Trace.getStackTrace((Throwable)cex));
                if (bActive) continue;
                retVals.add(sd);
            }
            catch (RemoteFileOperationException rex) {
                Trace.out((String)("REMOTEFILEOPERATIONEXCEPTION: calling areNodesAlive message:" + rex.getMessage()));
                VerificationLogData.logError("REMOTEFILEOPERATIONEXCEPTION: " + rex.getMessage() + "\n" + Trace.getStackTrace((Throwable)rex));
                if (bActive) continue;
                retVals.add(sd);
            }
        }
        return retVals;
    }

    private String getScanIps(List<scanData> sdList) {
        String scanIPs = null;
        for (scanData sd : sdList) {
            if (scanIPs == null) {
                scanIPs = sd.getAddress();
                continue;
            }
            scanIPs = scanIPs + "," + sd.getAddress();
        }
        return scanIPs == null ? "" : scanIPs;
    }

    private Map<String, List<scanData>> classifyVIPsBySubnet(Scan scan, List<InterfaceInfo> ifInfos, List<scanData> badSdList) {
        HashMap<String, List<scanData>> subnetMap = new HashMap<String, List<scanData>>();
        List<scanData> sdList = scan.sdList;
        List<scanData> sds = null;
        for (scanData sd : sdList) {
            InetAddress scanIPv4 = null;
            InetAddress scanIPv6 = null;
            String scanIP = null;
            try {
                if (sd.l_scanIpv4Address != null) {
                    scanIP = sd.l_scanIpv4Address.replaceFirst("/", "");
                    scanIPv4 = InetAddress.getByName(scanIP);
                }
                if (sd.l_scanIpv6Address != null) {
                    scanIP = sd.l_scanIpv6Address.replaceFirst("/", "");
                    scanIPv6 = InetAddress.getByName(scanIP);
                }
                InetAddress subnetIPv4 = null;
                InetAddress subnetIPv6 = null;
                for (InterfaceInfo ifInfo : ifInfos) {
                    if (scanIPv4 != null && ifInfo.isIPV4() && this.checkSubNetwork(scanIPv4, ifInfo)) {
                        subnetIPv4 = InetAddress.getByName(ifInfo.getSubnet());
                    }
                    if (scanIPv6 == null || !ifInfo.isIPV6() || !this.checkSubNetwork(scanIPv6, ifInfo)) continue;
                    subnetIPv6 = InetAddress.getByName(ifInfo.getSubnet());
                }
                if (scanIPv4 != null && subnetIPv4 == null || scanIPv6 != null && subnetIPv6 == null) {
                    Trace.out((String)("Scan VIP4 " + scanIPv4 + " or Scan VIP6" + scanIPv6 + " did not have any common subnet"));
                    badSdList.add(sd);
                    continue;
                }
                if (scanIPv4 != null && subnetIPv4.equals(scan.netIpv4Subnet) || scanIPv6 != null && subnetIPv6.equals(scan.netIpv6Subnet)) {
                    Trace.out((String)("Scan VIP " + sd.l_vipUserAssignedName + " is on the subnet " + subnetIPv4 + " and/or " + subnetIPv6));
                    Trace.out((String)("VIP subnets does not match with any of the network subnets " + scan.netIpv4Subnet + " and/or " + scan.netIpv6Subnet + "of SCAN " + scan.sName));
                    badSdList.add(sd);
                    continue;
                }
                Trace.out((String)("adding " + sd.l_vipUserAssignedName + " to subnet map " + subnetIPv4 + " and/or " + subnetIPv6));
                if (subnetIPv4 != null) {
                    sds = (ArrayList<scanData>)subnetMap.get(subnetIPv4.getHostAddress());
                    if (sds == null) {
                        sds = new ArrayList<scanData>();
                        subnetMap.put(subnetIPv4.getHostAddress(), sds);
                    }
                    sds.add(sd);
                }
                if (subnetIPv6 == null) continue;
                sds = (List)subnetMap.get(subnetIPv6.getHostAddress());
                if (sds == null) {
                    sds = new ArrayList();
                    subnetMap.put(subnetIPv6.getHostAddress(), sds);
                }
                sds.add(sd);
            }
            catch (UnknownHostException uhEx) {
                Trace.out((String)("UnknownHostException occured while getting scan address: " + sd.getAddress()));
                Trace.out((Exception)uhEx);
                this.m_resultSet.addErrorDescription(new ErrorDescription(uhEx.getMessage()));
            }
        }
        return subnetMap;
    }

    private boolean checkSubNetwork(InetAddress scanIP, InterfaceInfo ifInfo) throws UnknownHostException {
        byte[] netmask;
        int i = 0;
        byte[] ip1 = scanIP.getAddress();
        if (ip1.length != (netmask = InetAddress.getByName(ifInfo.getNetMask()).getAddress()).length) {
            Trace.out((String)("scanIP '" + scanIP + "' and  InterfaceInfo '" + ifInfo.toString() + "' are not same type of address family"));
            String errMsg = MessageBundle.getMessage((MessageKey)PrCiMsgID.IPADDR_SUBNETMASK_LENGTH_MISMATCH, (boolean)true, (Object[])new Object[]{scanIP, ifInfo.getNetMask()});
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        byte[] subnet = new byte[ip1.length];
        for (i = 0; i < ip1.length; ++i) {
            subnet[i] = (byte)(ip1[i] & netmask[i]);
        }
        byte[] ifSubnet = InetAddress.getByName(ifInfo.getSubnet()).getAddress();
        for (i = 0; i < ifSubnet.length && subnet[i] == ifSubnet[i]; ++i) {
        }
        return i == ifSubnet.length;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9500", false);
    }

    @Override
    public String getTaskID() {
        return "SCAN";
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9600", false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    private class Scan {
        String sName = null;
        DHCPServerType netiPv4DhcpType;
        String netIpv4Subnet = null;
        DHCPServerType netIpv6DhcpType;
        String netIpv6Subnet = null;
        List<scanData> sdList = new ArrayList<scanData>();

        private Scan() {
        }

        public String getSubnets() {
            StringBuilder subnets = new StringBuilder();
            if (this.netIpv4Subnet != null) {
                subnets.append(this.netIpv4Subnet);
            }
            if (subnets.length() != 0 && this.netIpv6Subnet != null) {
                subnets.append(',');
            }
            if (this.netIpv6Subnet != null) {
                subnets.append(this.netIpv6Subnet);
            }
            return subnets.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\nscanName: ");
            sb.append(this.sName);
            sb.append("\nnetiPv4DhcpType: ");
            sb.append(this.netiPv4DhcpType);
            sb.append("\nnetIpv4Subnet: ");
            sb.append(this.netIpv4Subnet);
            sb.append("\nnetIpv6DhcpType: ");
            sb.append(this.netIpv6DhcpType);
            sb.append("\nnetIpv6Subnet: ");
            sb.append(this.netIpv6Subnet);
            for (scanData sd : this.sdList) {
                sb.append("\n===============");
                sb.append(sd.toString());
            }
            return sb.toString();
        }
    }

    private class scanData {
        private String l_vipName;
        private String l_scanIpv4Address;
        private String l_scanIpv6Address;
        private String l_vipUserAssignedName;
        private String l_vipNode;
        private String l_lsnrName;
        private int l_portNum;
        private boolean l_vipRunning;
        private boolean l_lsnrRunning;

        private scanData(String vipName, String userAssignedName, String addressIpv4, String addressIpv6, String vipNode, String lsnrName, int portNum, boolean vipRunning, boolean lsnrRunning) {
            this.l_vipName = vipName;
            this.l_vipUserAssignedName = userAssignedName;
            this.l_scanIpv4Address = addressIpv4;
            this.l_scanIpv6Address = addressIpv6;
            this.l_vipNode = vipNode;
            this.l_lsnrName = lsnrName;
            this.l_portNum = portNum;
            this.l_vipRunning = vipRunning;
            this.l_lsnrRunning = lsnrRunning;
        }

        private String getAddress() {
            return this.l_scanIpv4Address;
        }

        private String getIpv6Address() {
            return this.l_scanIpv6Address;
        }

        private String getVIPName() {
            return this.l_vipName;
        }

        private String getUserAssignedName() {
            return this.l_vipUserAssignedName;
        }

        private String getVipNode() {
            return this.l_vipNode;
        }

        private String getLsnrName() {
            return this.l_lsnrName;
        }

        private int getPort() {
            return this.l_portNum;
        }

        private boolean getVipRunning() {
            return this.l_vipRunning;
        }

        private boolean getLsnrRunning() {
            return this.l_lsnrRunning;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n    vipName: " + this.l_vipName);
            sb.append("\n    ipv4Address: " + this.l_scanIpv4Address);
            sb.append("\n    ipv6Address: " + this.l_scanIpv6Address);
            sb.append("\n    vipNode: " + this.l_vipNode);
            sb.append("\n    lsnrName: " + this.l_lsnrName);
            sb.append("\n    port: " + this.l_portNum);
            sb.append("\n    vipRunning: " + this.l_vipRunning);
            sb.append("\n    lsnrRunning: " + this.l_lsnrRunning);
            sb.append("\n");
            return sb.toString();
        }
    }
}

